/*
 * Decompiled with CFR 0.152.
 */
package no.statkart.launcher.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import no.statkart.launcher.client.Feil;
import no.statkart.launcher.client.Parametre;

class InputDialog {
    private Feil feil;
    private String tittel;
    private String melding;
    private Path iconPath;
    private boolean visTjener = true;
    private boolean visBrukerPassord = true;
    private boolean visHeap = true;
    private List<Parametre> tidligereParametre = new ArrayList<Parametre>();
    private final Parametre fallback = new Parametre();
    private Parametre forrige;
    private JComboBox<String> inputTjener;
    private JTextField inputBrukernavn;
    private JPasswordField inputPassord;
    private JTextField inputHeap;

    InputDialog() {
    }

    InputDialog medTittel(String tittel) {
        this.tittel = tittel;
        return this;
    }

    InputDialog medMelding(String melding) {
        this.melding = melding;
        return this;
    }

    InputDialog medIconPath(Path iconPath) {
        this.iconPath = iconPath;
        return this;
    }

    InputDialog visTjener(boolean visTjener) {
        this.visTjener = visTjener;
        return this;
    }

    InputDialog visBrukerPassord(boolean visBrukerPassord) {
        this.visBrukerPassord = visBrukerPassord;
        return this;
    }

    InputDialog visHeap(boolean visHeap) {
        this.visHeap = visHeap;
        return this;
    }

    InputDialog medTidligereFeil(Feil feil) {
        this.feil = feil;
        return this;
    }

    InputDialog medTidligereInputParametre(List<Parametre> listeAvParametre) {
        this.tidligereParametre = new ArrayList<Parametre>(listeAvParametre);
        return this;
    }

    Parametre innhentInputParametre() {
        JPanel panel = new JPanel(new GridBagLayout());
        int yPanel = 0;
        if (this.melding != null) {
            yPanel = this.leggTilMelding(panel, yPanel);
        }
        if (this.visTjener) {
            yPanel = this.leggTilTjener(panel, yPanel);
        }
        if (this.visBrukerPassord) {
            yPanel = this.leggTilBrukernavnOgPassord(panel, yPanel);
        }
        if (this.trengerAvansert()) {
            yPanel = this.leggTilAvansert(panel, yPanel);
        }
        this.leggTilFeil(panel, yPanel);
        if (this.dialogOK(panel)) {
            return this.aktuelleInputParametre();
        }
        return null;
    }

    private int leggTilMelding(JPanel panel, int y) {
        JLabel labelMelding = new JLabel(this.melding, 2);
        panel.add((Component)labelMelding, this.medPosisjon(0, y, 1, 0, new Insets(0, 2, 10, 2)));
        return y + 1;
    }

    private int leggTilTjener(JPanel panel, int y) {
        JLabel labelTjener = new JLabel("Tjener", 4);
        panel.add((Component)labelTjener, this.medPosisjon(0, y, 0, 1));
        panel.add(this.opprettInputTjener(), this.medPosisjon(1, y, 1, 2));
        return y + 1;
    }

    private int leggTilBrukernavnOgPassord(JPanel panel, int y) {
        JLabel labelBrukernavn = new JLabel("Brukernavn", 4);
        panel.add((Component)labelBrukernavn, this.medPosisjon(0, y, 0, 1));
        panel.add((Component)this.opprettInputBrukernavn(), this.medPosisjon(1, y, 1, 2));
        JLabel labelPassord = new JLabel("Passord", 4);
        panel.add((Component)labelPassord, this.medPosisjon(0, y + 1, 0, 1));
        panel.add((Component)this.opprettInputPassord(), this.medPosisjon(1, y + 1, 1, 2));
        return y + 2;
    }

    private void leggTilHeap(JPanel panel, int y) {
        JLabel labelHeap = new JLabel("Tildelt minne", 4);
        panel.add((Component)labelHeap, this.medPosisjon(0, y, 0, 1));
        JTextField inputHeap = this.opprettInputHeap();
        panel.add((Component)inputHeap, this.medPosisjon(1, y, 1, -1));
        JLabel labelHeapUnit = new JLabel("MB");
        panel.add((Component)labelHeapUnit, this.medPosisjon(2, y, 0, 1));
    }

    private void leggTilFeil(JPanel panel, int y) {
        if (this.feil != null) {
            JLabel labelFeilmelding = new JLabel(this.feil.tilFeilmelding());
            labelFeilmelding.setForeground(this.responsfarge());
            panel.add((Component)labelFeilmelding, this.medPosisjon(0, y, 1, 0, new Insets(10, 2, 2, 2)));
        }
    }

    private boolean trengerAvansert() {
        return this.visHeap;
    }

    private Color responsfarge() {
        return this.feil.erRedFlag() ? Color.RED : Color.BLACK;
    }

    private int leggTilAvansert(JPanel panel, int y) {
        JPanel avansert = new JPanel(new GridBagLayout());
        avansert.setBorder(new EmptyBorder(0, 10, 0, 0));
        avansert.setVisible(this.feil != null && this.feil.erHeapFeil());
        JButton switcher = this.opprettAvansertPanelSwitcher(avansert);
        panel.add((Component)switcher, this.medPosisjon(0, y, 1, 3, new Insets(10, 2, 2, 2)));
        int yAvansert = 0;
        if (this.visHeap) {
            this.leggTilHeap(avansert, yAvansert);
        }
        panel.add((Component)avansert, this.medPosisjon(0, y + 1, 1, 0));
        return y + 2;
    }

    private JButton opprettAvansertPanelSwitcher(JPanel panelToSwitch) {
        Color linkColor = new Color(39, 113, 187);
        JButton switcher = new JButton(this.switcherLabel(panelToSwitch));
        switcher.setBorderPainted(false);
        switcher.setContentAreaFilled(false);
        switcher.setForeground(linkColor);
        switcher.setHorizontalAlignment(2);
        switcher.getModel().addChangeListener(e -> {
            ButtonModel model = (ButtonModel)e.getSource();
            if (model.isRollover()) {
                switcher.setForeground(linkColor.brighter());
            } else {
                switcher.setForeground(linkColor);
            }
        });
        switcher.addActionListener(e -> {
            panelToSwitch.setVisible(!panelToSwitch.isVisible());
            switcher.setText(this.switcherLabel(panelToSwitch));
            ((Window)panelToSwitch.getRootPane().getParent()).pack();
        });
        return switcher;
    }

    private String switcherLabel(JPanel panelToSwitch) {
        return panelToSwitch.isVisible() ? "\u25bc Avansert" : "\u25b6 Avansert";
    }

    private JComboBox<String> opprettInputTjener() {
        this.inputTjener = new JComboBox<String>(this.finnTjenere());
        if (this.feil != null) {
            this.inputTjener.setSelectedItem(this.feil.getInputParametre().getTjener());
        }
        this.forrige = this.aktuelleInputParametre();
        this.inputTjener.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.endretTjener();
                this.forrige = this.aktuelleInputParametre();
            }
        });
        this.inputTjener.setEditable(true);
        this.inputTjener.setPrototypeDisplayValue("https://asdf.asdf.asdf.asdf:1234/asdfasdf/");
        return this.inputTjener;
    }

    private JTextField opprettInputBrukernavn() {
        this.inputBrukernavn = new JTextField();
        this.inputBrukernavn.setText(this.aktuelleInputParametre().getBrukernavn());
        this.inputBrukernavn.getDocument().addDocumentListener(e -> this.endretBrukernavn());
        return this.inputBrukernavn;
    }

    private JPasswordField opprettInputPassord() {
        this.inputPassord = new JPasswordField();
        this.inputPassord.getDocument().addDocumentListener(e -> this.endretPassord());
        return this.inputPassord;
    }

    private JTextField opprettInputHeap() {
        this.inputHeap = new JTextField();
        this.inputHeap.setText(this.aktuelleInputParametre().getHeap());
        this.inputHeap.getDocument().addDocumentListener(e -> this.endretHeap());
        return this.inputHeap;
    }

    private String[] finnTjenere() {
        ArrayList<String> resultat = new ArrayList<String>();
        for (Parametre param : this.tidligereParametre) {
            resultat.add(param.getTjener());
        }
        if (this.feil != null && !resultat.contains(this.feil.getInputParametre().getTjener())) {
            resultat.add(0, this.feil.getInputParametre().getTjener());
        }
        return resultat.toArray(new String[0]);
    }

    private Parametre aktuelleInputParametre() {
        if (this.inputTjener == null) {
            if (this.tidligereParametre.isEmpty()) {
                return this.fallback;
            }
            return this.tidligereParametre.get(0);
        }
        int idx = this.inputTjener.getSelectedIndex();
        if (idx < 0) {
            return this.fallback;
        }
        if (this.tidligereParametre.size() < this.inputTjener.getItemCount()) {
            if (idx == 0) {
                return this.feil == null ? this.fallback : this.feil.getInputParametre();
            }
            return this.tidligereParametre.get(idx - 1);
        }
        return this.tidligereParametre.get(idx);
    }

    private void endretTjener() {
        if (this.inputTjener.getSelectedIndex() < 0) {
            this.fallback.medTjener((String)this.inputTjener.getSelectedItem()).medBrukernavn(this.forrige.getBrukernavn()).medPassord(this.forrige.getPassord()).medHeap(this.forrige.getHeap());
        }
        Parametre param = this.aktuelleInputParametre();
        if (this.inputBrukernavn != null) {
            this.inputBrukernavn.setText(param.getBrukernavn());
        }
        if (this.inputHeap != null) {
            this.inputHeap.setText(param.getHeap());
        }
    }

    private void endretBrukernavn() {
        this.aktuelleInputParametre().medBrukernavn(this.inputBrukernavn.getText());
    }

    private void endretPassord() {
        this.aktuelleInputParametre().medPassord(this.inputPassord.getPassword());
    }

    private void endretHeap() {
        this.aktuelleInputParametre().medHeap(this.inputHeap.getText());
    }

    private boolean dialogOK(Object message) throws HeadlessException {
        if (!Files.exists(this.iconPath, new LinkOption[0])) {
            throw new IllegalStateException("Finner ikke 'login.png' i work-katalogen");
        }
        ImageIcon icon = new ImageIcon(this.iconPath.toString());
        JOptionPane pane = new JOptionPane(message, 3, 1, icon, new Object[]{"OK", "Avbryt"}, "OK");
        pane.setComponentOrientation(JOptionPane.getRootFrame().getComponentOrientation());
        pane.selectInitialValue();
        JDialog dialog = pane.createDialog(null, this.tittel);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                InputDialog.this.setFokus();
            }
        });
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = pane.getValue();
        return "OK".equals(selectedValue);
    }

    private GridBagConstraints medPosisjon(int gridx, int gridy, int weightx, int gridwidth) {
        return this.medPosisjon(gridx, gridy, weightx, gridwidth, new Insets(0, 2, 2, 2));
    }

    private GridBagConstraints medPosisjon(int gridx, int gridy, int weightx, int gridwidth, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, 1, weightx, 0.0, 10, 0, insets, 0, 0);
        gbc.fill = 2;
        return gbc;
    }

    private void setFokus() {
        Feil f;
        Feil feil = f = this.feil == null ? this.aktuelleInputParametre().tilFeil() : this.feil;
        if (f == null) {
            this.fokusBrukernavn();
        } else if (f.erTjenerfeil()) {
            this.fokusTjener();
        } else if (f.erBrukerPassordFeil()) {
            this.fokusBrukernavn();
        } else if (f.erHeapFeil()) {
            this.fokusHeap();
        }
    }

    private void fokusTjener() {
        if (this.inputTjener != null) {
            SwingUtilities.invokeLater(() -> {
                this.inputTjener.requestFocusInWindow();
                ((JTextField)this.inputTjener.getEditor().getEditorComponent()).selectAll();
            });
        }
    }

    private void fokusBrukernavn() {
        if (this.inputBrukernavn != null) {
            SwingUtilities.invokeLater(() -> {
                this.inputBrukernavn.requestFocusInWindow();
                this.inputBrukernavn.selectAll();
            });
        }
    }

    private void fokusHeap() {
        if (this.inputHeap != null) {
            SwingUtilities.invokeLater(() -> {
                this.inputHeap.requestFocusInWindow();
                this.inputHeap.selectAll();
            });
        }
    }

    @FunctionalInterface
    static interface SimpleDocumentListener
    extends DocumentListener {
        public void update(DocumentEvent var1);

        @Override
        default public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        default public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        default public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }
    }
}

